package com.connectfour;

import shared.Message;
import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;

public class ConnectFourGame extends Activity {
	
	private ConnectFourView m_view;
	public static ConnectFourGame instance;
	
	public void onCreate(Bundle bundle) {
		super.onCreate(bundle);
		
		// store a global reference to the game activity
		instance = this;
		
		// set application view to connect four layout
		setContentView(R.layout.connectfour);
		
		// obtain game view
		m_view = (ConnectFourView) findViewById(R.id.connectfourView);
		m_view.setFocusable(true);
		m_view.setFocusableInTouchMode(true);
	}
	
	// handle key presses
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		// if the key is the back button and the game is online multiplayer
		if(ConnectFour.instance.getGameType() == GameType.Multiplayer && keyCode == KeyEvent.KEYCODE_BACK) {
			// generate a message indicating that the user left the game session
			Message leftSession = new Message("Left Session");
			leftSession.setAttribute("User Name", ConnectFour.instance.getUserName());
			
			// send the message to the server
			ConnectFour.instance.sendMessageToServer(leftSession);
		}
		
		return super.onKeyDown(keyCode, event);
	}
	
}
